/*
 * Decompiled with CFR 0.152.
 */
package io.github.fablabsmc.fablabs.impl.fiber.tree;

import io.github.fablabsmc.fablabs.api.fiber.v1.FiberId;
import io.github.fablabsmc.fablabs.api.fiber.v1.exception.IllegalTreeStateException;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.SerializableType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.Commentable;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigAttribute;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigBranch;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigNode;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class ConfigNodeImpl
implements ConfigNode,
Commentable {
    private final Map<FiberId, ConfigAttribute<?>> attributes = new TreeMap(Comparator.comparing(FiberId::toString));
    @Nonnull
    private final String name;
    @Nullable
    private final String comment;
    @Nullable
    private ConfigBranch parent;

    public ConfigNodeImpl(@Nonnull String name, @Nullable String comment) {
        this.name = name;
        this.comment = comment;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getComment() {
        return this.comment;
    }

    @Override
    @Nullable
    public ConfigBranch getParent() {
        return this.parent;
    }

    @Override
    public Map<FiberId, ConfigAttribute<?>> getAttributes() {
        return this.attributes;
    }

    @Override
    public <A> ConfigAttribute<A> getOrCreateAttribute(FiberId id, SerializableType<A> attributeType, @Nullable A defaultValue) {
        ConfigAttribute attr = this.getAttributes().computeIfAbsent(id, i -> ConfigAttribute.create(i, attributeType, defaultValue));
        ConfigNodeImpl.checkAttributeType(attributeType, attr);
        return attr;
    }

    @Override
    public <A> Optional<A> getAttributeValue(FiberId id, SerializableType<A> expectedType) {
        ConfigAttribute<?> attr = this.attributes.get(id);
        if (attr != null) {
            ConfigNodeImpl.checkAttributeType(expectedType, attr);
            A a = expectedType.cast(attr.getValue());
            return Optional.of(a);
        }
        return Optional.empty();
    }

    @Override
    public <R, A> Optional<R> getAttributeValue(FiberId id, ConfigType<R, A, ?> type) {
        return this.getAttributeValue(id, (SerializableType<A>)type.getSerializedType()).map(type::toRuntimeType);
    }

    private static <A> void checkAttributeType(SerializableType<A> expectedType, ConfigAttribute<?> attr) {
        if (!expectedType.equals(attr.getConfigType())) {
            throw new ClassCastException("Attempt to retrieve a value of type " + expectedType + " from attribute with type " + attr.getConfigType());
        }
    }

    @Override
    public void detach() {
        if (this.parent != null) {
            this.parent.getItems().remove(this);
        }
        this.parent = null;
    }

    @Override
    public void attachTo(ConfigBranch parent) {
        if (this.parent != null && this.parent != parent) {
            throw new IllegalTreeStateException(this + " needs to be detached before changing the parent");
        }
        if (parent != null && !parent.getItems().contains(this)) {
            parent.getItems().add(this);
        }
        this.parent = parent;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.getName() + ", comment=" + this.getComment() + "]";
    }
}

